// Librairies

// Variables globales

// Tableau d'images
PImage[] signe;

// Nom des images
String[] nomSigne;

//Entrées
int x, y;
color c = color(255);

// Appel de la librairie "PDF EXPORT"
import processing.pdf.*;

void setup() {
  
    size(1000, 1000);
    noLoop();
    smooth();
    fill(c);
    background(255);
  
    //Appel des images via le dossier texte
    nomSigne = loadStrings("nomSigne.txt");
    
    //Création du tableau d'image 
    signe = new PImage[nomSigne.length];
    
    for (int i=0;i<nomSigne.length;i++){
        PImage im = loadImage(nomSigne[i]);
        signe[i] = im;
    }
  
    //Nom de l'enregistrement sous pdf, dans le dossier signesPDF. Changer manuellement le nom à chaque nouvel enregistrement
    beginRecord(PDF, "signesPDF/signe_01.pdf");
 
}

void draw() { 
  
    rect(0,0,1000,1000); // rectangle de fond afin d'effacer les dessins précédents
    
    int N = (int)random(0,4); // nombre d'image N à afficher, entre 0 et 3
    
    for (int i=0;i<N;i++){ // répéter N fois
        int indiceSigne = floor(random(0,signe.length)); //Générer un nombre aléatoire entre 0 et le nombre d'image total
        image(signe[indiceSigne],random(200,400),random(0,500), 300, 300); //image(nom,random(position x),random(position y),largeur,hauteur)
    }
  
    //enregistrement une fois que le signe a fait un affichage et qu'on ferme la fenetre
    endRecord(); //l'enregistrement s'arrete
  
}


void mousePressed () {  //<>//
  
    redraw();
    
}