/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import milchreis.imageprocessing.Histogram;
import milchreis.imageprocessing.utils.Tools;
import processing.core.PImage;

public class AutoBalance {
    public static int[] balancing(PImage pImage) {
        int[] nArray = Histogram.histogtam(pImage);
        int[] nArray2 = new int[256];
        nArray2 = new Tools().getArray(nArray2, 0);
        int n = 0;
        float f = (float)(255.0 / (double)(pImage.width * pImage.height));
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = (int)((float)(n += nArray[i]) * f);
            nArray2[i] = n2 > 255 ? 255 : n2;
        }
        return nArray2;
    }

    public static PImage apply(PImage pImage) {
        int[] nArray = AutoBalance.balancing(pImage);
        PImage pImage2 = Tools.createImage(pImage.width, pImage.height, 1, pImage);
        pImage2.loadPixels();
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int[] nArray2 = Tools.getColors(pImage, i, j);
                int n = nArray[nArray2[0]];
                int n2 = nArray[nArray2[1]];
                int n3 = nArray[nArray2[2]];
                pImage2.set(i, j, n << 16 | n2 << 8 | n3);
            }
        }
        pImage2.updatePixels();
        return pImage2;
    }
}

