/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import java.util.Arrays;
import milchreis.imageprocessing.utils.Tools;
import processing.core.PImage;

public class CannyEdgeDetector {
    private static final float GAUSSIAN_CUT_OFF = 0.005f;
    private static final float MAGNITUDE_SCALE = 100.0f;
    private static final float MAGNITUDE_LIMIT = 1000.0f;
    private static final int MAGNITUDE_MAX = 100000;
    private int height;
    private int width;
    private int picsize;
    private int[] data;
    private int[] magnitude;
    private float gaussianKernelRadius;
    private float lowThreshold;
    private float highThreshold;
    private int gaussianKernelWidth;
    private boolean contrastNormalized;
    private float[] xConv;
    private float[] yConv;
    private float[] xGradient;
    private float[] yGradient;

    public static PImage apply(PImage pImage, float f, float f2, float f3, int n, boolean bl) {
        CannyEdgeDetector cannyEdgeDetector = new CannyEdgeDetector();
        cannyEdgeDetector.lowThreshold = f;
        cannyEdgeDetector.highThreshold = f2;
        cannyEdgeDetector.gaussianKernelRadius = f3;
        cannyEdgeDetector.gaussianKernelWidth = n;
        cannyEdgeDetector.contrastNormalized = bl;
        cannyEdgeDetector.width = pImage.width;
        cannyEdgeDetector.height = pImage.height;
        cannyEdgeDetector.picsize = cannyEdgeDetector.width * cannyEdgeDetector.height;
        cannyEdgeDetector.initArrays();
        cannyEdgeDetector.readLuminance(pImage);
        if (cannyEdgeDetector.contrastNormalized) {
            cannyEdgeDetector.normalizeContrast();
        }
        cannyEdgeDetector.computeGradients(cannyEdgeDetector.gaussianKernelRadius, cannyEdgeDetector.gaussianKernelWidth);
        int n2 = Math.round(cannyEdgeDetector.lowThreshold * 100.0f);
        int n3 = Math.round(cannyEdgeDetector.highThreshold * 100.0f);
        cannyEdgeDetector.performHysteresis(n2, n3);
        cannyEdgeDetector.thresholdEdges();
        PImage pImage2 = cannyEdgeDetector.writeEdges(cannyEdgeDetector.data);
        pImage2.parent = pImage.parent;
        return pImage2;
    }

    public static PImage apply(PImage pImage) {
        return CannyEdgeDetector.apply(pImage, 2.5f, 7.5f, 2.0f, 16, false);
    }

    private void initArrays() {
        if (this.data == null || this.picsize != this.data.length) {
            this.data = new int[this.picsize];
            this.magnitude = new int[this.picsize];
            this.xConv = new float[this.picsize];
            this.yConv = new float[this.picsize];
            this.xGradient = new float[this.picsize];
            this.yGradient = new float[this.picsize];
        }
    }

    private void computeGradients(float f, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        float f2;
        int n6;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (n6 = 0; !(n6 >= n || (f2 = this.gaussian(n6, f)) <= 0.005f && n6 >= 2); ++n6) {
            float f3 = this.gaussian((float)n6 - 0.5f, f);
            float f4 = this.gaussian((float)n6 + 0.5f, f);
            fArray[n6] = (f2 + f3 + f4) / 3.0f / ((float)Math.PI * 2 * f * f);
            fArray2[n6] = f4 - f3;
        }
        int n7 = n6 - 1;
        int n8 = this.width - (n6 - 1);
        int n9 = this.width * (n6 - 1);
        int n10 = this.width * (this.height - (n6 - 1));
        for (n5 = n7; n5 < n8; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                float f5;
                int n11 = n5 + n4;
                float f6 = f5 = (float)this.data[n11] * fArray[0];
                n3 = this.width;
                for (n2 = 1; n2 < n6; ++n2) {
                    f6 += fArray[n2] * (float)(this.data[n11 - n3] + this.data[n11 + n3]);
                    f5 += fArray[n2] * (float)(this.data[n11 - n2] + this.data[n11 + n2]);
                    n3 += this.width;
                }
                this.yConv[n11] = f6;
                this.xConv[n11] = f5;
            }
        }
        for (n5 = n7; n5 < n8; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                float f7 = 0.0f;
                int n12 = n5 + n4;
                for (int i = 1; i < n6; ++i) {
                    f7 += fArray2[i] * (this.yConv[n12 - i] - this.yConv[n12 + i]);
                }
                this.xGradient[n12] = f7;
            }
        }
        for (n5 = n6; n5 < this.width - n6; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                float f8 = 0.0f;
                int n13 = n5 + n4;
                int n14 = this.width;
                for (n2 = 1; n2 < n6; ++n2) {
                    f8 += fArray2[n2] * (this.xConv[n13 - n14] - this.xConv[n13 + n14]);
                    n14 += this.width;
                }
                this.yGradient[n13] = f8;
            }
        }
        n7 = n6;
        n8 = this.width - n6;
        n9 = this.width * n6;
        n10 = this.width * (this.height - n6);
        for (n5 = n7; n5 < n8; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                block16: {
                    float f9;
                    block17: {
                        float f10;
                        float f11;
                        float f12;
                        float f13;
                        float f14;
                        float f15;
                        float f16;
                        float f17;
                        block18: {
                            float f18;
                            float f19;
                            float f20;
                            block14: {
                                float f21;
                                float f22;
                                float f23;
                                block15: {
                                    float f24;
                                    int n15 = n5 + n4;
                                    int n16 = n15 - this.width;
                                    int n17 = n15 + this.width;
                                    n2 = n15 - 1;
                                    n3 = n15 + 1;
                                    int n18 = n16 - 1;
                                    int n19 = n16 + 1;
                                    int n20 = n17 - 1;
                                    int n21 = n17 + 1;
                                    f17 = this.xGradient[n15];
                                    f16 = this.yGradient[n15];
                                    f9 = this.hypot(f17, f16);
                                    f15 = this.hypot(this.xGradient[n16], this.yGradient[n16]);
                                    f14 = this.hypot(this.xGradient[n17], this.yGradient[n17]);
                                    f20 = this.hypot(this.xGradient[n2], this.yGradient[n2]);
                                    f19 = this.hypot(this.xGradient[n3], this.yGradient[n3]);
                                    f23 = this.hypot(this.xGradient[n19], this.yGradient[n19]);
                                    f13 = this.hypot(this.xGradient[n21], this.yGradient[n21]);
                                    f22 = this.hypot(this.xGradient[n20], this.yGradient[n20]);
                                    f12 = this.hypot(this.xGradient[n18], this.yGradient[n18]);
                                    if (!(f17 * f16 <= 0.0f)) break block14;
                                    if (!(Math.abs(f17) >= Math.abs(f16))) break block15;
                                    f11 = Math.abs(f17 * f9);
                                    if (!(f24 >= Math.abs(f16 * f23 - (f17 + f16) * f19)) || !(f11 > Math.abs(f16 * f22 - (f17 + f16) * f20))) break block16;
                                    break block17;
                                }
                                f11 = Math.abs(f16 * f9);
                                if (!(f21 >= Math.abs(f17 * f23 - (f16 + f17) * f15)) || !(f11 > Math.abs(f17 * f22 - (f16 + f17) * f14))) break block16;
                                break block17;
                            }
                            if (!(Math.abs(f17) >= Math.abs(f16))) break block18;
                            f11 = Math.abs(f17 * f9);
                            if (!(f18 >= Math.abs(f16 * f13 + (f17 - f16) * f19)) || !(f11 > Math.abs(f16 * f12 + (f17 - f16) * f20))) break block16;
                            break block17;
                        }
                        f11 = Math.abs(f16 * f9);
                        if (!(f10 >= Math.abs(f17 * f13 + (f16 - f17) * f14)) || !(f11 > Math.abs(f17 * f12 + (f16 - f17) * f15))) break block16;
                    }
                    this.magnitude[n15] = f9 >= 1000.0f ? 100000 : (int)(100.0f * f9);
                    continue;
                }
                this.magnitude[n15] = 0;
            }
        }
    }

    private float hypot(float f, float f2) {
        return (float)Math.hypot(f, f2);
    }

    private float gaussian(float f, float f2) {
        return (float)Math.exp(-(f * f) / (2.0f * f2 * f2));
    }

    private void performHysteresis(int n, int n2) {
        Arrays.fill(this.data, 0);
        int n3 = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.data[n3] == 0 && this.magnitude[n3] >= n2) {
                    this.follow(j, i, n3, n);
                }
                ++n3;
            }
        }
    }

    private void follow(int n, int n2, int n3, int n4) {
        int n5 = n == 0 ? n : n - 1;
        int n6 = n == this.width - 1 ? n : n + 1;
        int n7 = n2 == 0 ? n2 : n2 - 1;
        int n8 = n2 == this.height - 1 ? n2 : n2 + 1;
        this.data[n3] = this.magnitude[n3];
        for (int i = n5; i <= n6; ++i) {
            for (int j = n7; j <= n8; ++j) {
                int n9 = i + j * this.width;
                if (j == n2 && i == n || this.data[n9] != 0 || this.magnitude[n9] < n4) continue;
                this.follow(i, j, n9, n4);
                return;
            }
        }
    }

    private void thresholdEdges() {
        for (int i = 0; i < this.picsize; ++i) {
            this.data[i] = this.data[i] > 0 ? -1 : -16777216;
        }
    }

    private int luminance(float f, float f2, float f3) {
        return Math.round(0.299f * f + 0.587f * f2 + 0.114f * f3);
    }

    private void readLuminance(PImage pImage) {
        pImage.loadPixels();
        int[] nArray = pImage.pixels;
        for (int i = 0; i < this.picsize; ++i) {
            int n = nArray[i];
            int n2 = (n & 0xFF0000) >> 16;
            int n3 = (n & 0xFF00) >> 8;
            int n4 = n & 0xFF;
            this.data[i] = this.luminance(n2, n3, n4);
        }
        pImage.updatePixels();
    }

    private void normalizeContrast() {
        int n;
        int[] nArray = new int[256];
        for (int i = 0; i < this.data.length; ++i) {
            int n2 = this.data[i];
            nArray[n2] = nArray[n2] + 1;
        }
        int[] nArray2 = new int[256];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            int n5 = (n3 += nArray[n]) * 255 / this.picsize;
            for (int i = n4 + 1; i <= n5; ++i) {
                nArray2[i] = n;
            }
            n4 = n5;
        }
        for (n = 0; n < this.data.length; ++n) {
            this.data[n] = nArray2[this.data[n]];
        }
    }

    private PImage writeEdges(int[] nArray) {
        PImage pImage = Tools.createImage(this.width, this.height, 1);
        pImage.pixels = nArray;
        pImage.updatePixels();
        return pImage;
    }
}

