/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import java.util.Arrays;
import milchreis.imageprocessing.utils.Tools;
import processing.core.PImage;

public class Stacker {
    public static PImage apply(PImage ... pImageArray) {
        return Stacker.apply(ALGORITHM.MEDIAN, pImageArray);
    }

    public static PImage apply(ALGORITHM aLGORITHM, PImage ... pImageArray) {
        if (pImageArray == null || pImageArray.length == 0) {
            return null;
        }
        int n = pImageArray[0].width;
        int n2 = pImageArray[0].height;
        PImage pImage = Tools.createImage(n, n2, 1, pImageArray[0]);
        int[] nArray = new int[pImageArray.length];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                for (n3 = 0; n3 < pImageArray.length; ++n3) {
                    if (aLGORITHM == ALGORITHM.MEDIAN) {
                        nArray[n3] = pImageArray[n3].get(i, j);
                    }
                    if (aLGORITHM != ALGORITHM.AVERAGE) continue;
                    int n7 = pImageArray[n3].get(i, j);
                    n4 += n7 >> 16 & 0xFF;
                    n5 += n7 >> 8 & 0xFF;
                    n6 += n7 & 0xFF;
                }
                n3 = 0;
                if (aLGORITHM == ALGORITHM.MEDIAN) {
                    Arrays.sort(nArray);
                    n3 = nArray[nArray.length / 2];
                }
                if (aLGORITHM == ALGORITHM.AVERAGE) {
                    n3 = 0xFF000000 | n4 / pImageArray.length << 16 | n5 / pImageArray.length << 8 | n6 / pImageArray.length;
                }
                pImage.set(i, j, n3);
            }
        }
        return pImage;
    }

    public static enum ALGORITHM {
        MEDIAN,
        AVERAGE;

    }
}

