/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import milchreis.imageprocessing.Histogram;
import milchreis.imageprocessing.utils.Tools;
import processing.core.PImage;

public class Threshold {
    public static PImage apply(PImage pImage, double d) {
        PImage pImage2 = Tools.createImage(pImage.width, pImage.height, 1, pImage);
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n = pImage.get(i, j);
                int n2 = (double)(n = n >> 16 & 0xFF) > d ? 255 : 0;
                n2 = n2 << 16 | n2 << 8 | n2;
                pImage2.set(i, j, n2);
            }
        }
        return pImage2;
    }

    public static PImage apply(PImage pImage) {
        double d = Threshold.otsuTreshold(pImage);
        return Threshold.apply(pImage, d);
    }

    public static int otsuTreshold(PImage pImage) {
        int[] nArray = Histogram.histogtam(pImage);
        int n = pImage.width * pImage.height;
        float f = 0.0f;
        for (int i = 0; i < 256; ++i) {
            f += (float)(i * nArray[i]);
        }
        float f2 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        float f3 = 0.0f;
        int n4 = 0;
        for (int i = 0; i < 256; ++i) {
            float f4;
            float f5;
            if ((n2 += nArray[i]) == 0) continue;
            n3 = n - n2;
            if (n3 == 0) break;
            float f6 = (f2 += (float)(i * nArray[i])) / (float)n2;
            if (!((f5 = (float)n2 * (float)n3 * (f6 - (f4 = (f - f2) / (float)n3)) * (f6 - f4)) > f3)) continue;
            f3 = f5;
            n4 = i;
        }
        return n4;
    }
}

