/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_Rgb2Bin;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_ARToolkitThreshold
implements INyARRasterFilter_Rgb2Bin {
    protected int _threshold;
    private IdoThFilterImpl _do_threshold_impl;

    public NyARRasterFilter_ARToolkitThreshold(int i_threshold, int i_in_raster_type) throws NyARException {
        if (!this.initInstance(i_threshold, i_in_raster_type, 262146)) {
            throw new NyARException();
        }
    }

    public NyARRasterFilter_ARToolkitThreshold(int i_threshold, int i_in_raster_type, int i_out_raster_type) throws NyARException {
        if (!this.initInstance(i_threshold, i_in_raster_type, i_out_raster_type)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(int i_threshold, int i_in_raster_type, int i_out_raster_type) {
        block0 : switch (i_out_raster_type) {
            case 262146: {
                switch (i_in_raster_type) {
                    case 65537: 
                    case 65538: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_BYTE1D_RGB_24();
                        break block0;
                    }
                    case 65793: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_BYTE1D_B8G8R8X8_32();
                        break block0;
                    }
                    case 65794: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_BYTE1D_X8R8G8B8_32();
                        break block0;
                    }
                    case 262402: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32();
                        break block0;
                    }
                    case 197121: {
                        this._do_threshold_impl = new doThFilterImpl_BUFFERFORMAT_WORD1D_R5G6B5_16LE();
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        this._threshold = i_threshold;
        return true;
    }

    public void setThreshold(int i_threshold) {
        this._threshold = i_threshold;
    }

    @Override
    public void doFilter(INyARRgbRaster i_input, NyARBinRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        NyARIntSize s = i_input.getSize();
        this._do_threshold_impl.doThFilter(i_input, 0, 0, s.w, s.h, this._threshold, i_output);
    }

    public void doFilter(INyARRgbRaster i_input, NyARIntRect i_area, NyARBinRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        this._do_threshold_impl.doThFilter(i_input, i_area.x, i_area.y, i_area.w, i_area.h, this._threshold, i_output);
    }

    protected static interface IdoThFilterImpl {
        public void doThFilter(INyARRaster var1, int var2, int var3, int var4, int var5, int var6, INyARRaster var7);
    }

    private class doThFilterImpl_BUFFERFORMAT_BYTE1D_B8G8R8X8_32
    implements IdoThFilterImpl {
        private doThFilterImpl_BUFFERFORMAT_BYTE1D_B8G8R8X8_32() {
        }

        @Override
        public void doThFilter(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int i_th, INyARRaster o_raster) {
            assert (i_raster.isEqualBufferType(65793));
            byte[] input = (byte[])i_raster.getBuffer();
            int[] output = (int[])o_raster.getBuffer();
            NyARIntSize s = i_raster.getSize();
            int th = i_th * 3;
            int skip_dst = s.w - i_w;
            int skip_src = skip_dst * 4;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_dst = i_t * s.w + i_l;
            int pt_src = pt_dst * 4;
            int y = i_h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    output[pt_dst++] = (input[pt_src + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    pt_src += 4;
                    --x;
                }
                while (x >= 0) {
                    output[pt_dst++] = (input[pt_src + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    pt_src += 4;
                    x -= 8;
                }
                pt_src += skip_src;
                pt_dst += skip_dst;
                --y;
            }
        }
    }

    private class doThFilterImpl_BUFFERFORMAT_BYTE1D_RGB_24
    implements IdoThFilterImpl {
        private doThFilterImpl_BUFFERFORMAT_BYTE1D_RGB_24() {
        }

        @Override
        public void doThFilter(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int i_th, INyARRaster o_raster) {
            assert (i_raster.isEqualBufferType(65538) || i_raster.isEqualBufferType(65537));
            byte[] input = (byte[])i_raster.getBuffer();
            int[] output = (int[])o_raster.getBuffer();
            int th = i_th * 3;
            NyARIntSize s = i_raster.getSize();
            int skip_dst = s.w - i_w;
            int skip_src = skip_dst * 3;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_dst = i_t * s.w + i_l;
            int pt_src = pt_dst * 3;
            int y = i_h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    output[pt_dst++] = (input[pt_src + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    pt_src += 3;
                    --x;
                }
                while (x >= 0) {
                    output[pt_dst++] = (input[pt_src + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 3) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 3) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 3) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 3) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 3) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 3) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 3) + 0] & 0xFF) + (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) <= th ? 0 : 1;
                    pt_src += 3;
                    x -= 8;
                }
                pt_src += skip_src;
                pt_dst += skip_dst;
                --y;
            }
        }
    }

    private class doThFilterImpl_BUFFERFORMAT_BYTE1D_X8R8G8B8_32
    implements IdoThFilterImpl {
        private doThFilterImpl_BUFFERFORMAT_BYTE1D_X8R8G8B8_32() {
        }

        @Override
        public void doThFilter(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int i_th, INyARRaster o_raster) {
            assert (i_raster.isEqualBufferType(65794));
            byte[] input = (byte[])i_raster.getBuffer();
            int[] output = (int[])o_raster.getBuffer();
            int th = i_th * 3;
            NyARIntSize s = i_raster.getSize();
            int skip_dst = s.w - i_w;
            int skip_src = skip_dst * 4;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_dst = i_t * s.w + i_l;
            int pt_src = pt_dst * 4;
            int y = i_h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    output[pt_dst++] = (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    pt_src += 4;
                    --x;
                }
                while (x >= 0) {
                    output[pt_dst++] = (input[pt_src + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    output[pt_dst++] = (input[(pt_src += 4) + 1] & 0xFF) + (input[pt_src + 2] & 0xFF) + (input[pt_src + 3] & 0xFF) <= th ? 0 : 1;
                    pt_src += 4;
                    x -= 8;
                }
                pt_src += skip_src;
                pt_dst += skip_dst;
                --y;
            }
        }
    }

    private class doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32
    implements IdoThFilterImpl {
        private doThFilterImpl_BUFFERFORMAT_INT1D_X8R8G8B8_32() {
        }

        @Override
        public void doThFilter(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int i_th, INyARRaster o_raster) {
            int pt_dst;
            int skip_src;
            assert (i_raster.isEqualBufferType(262402));
            int[] input = (int[])i_raster.getBuffer();
            int[] output = (int[])o_raster.getBuffer();
            int th = i_th * 3;
            NyARIntSize s = i_raster.getSize();
            int skip_dst = skip_src = s.w - i_w;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_src = pt_dst = i_t * s.w + i_l;
            int y = i_h - 1;
            while (y >= 0) {
                int v;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    --x;
                }
                while (x >= 0) {
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = (v >> 16 & 0xFF) + (v >> 8 & 0xFF) + (v & 0xFF) <= th ? 0 : 1;
                    x -= 8;
                }
                pt_src += skip_src;
                pt_dst += skip_dst;
                --y;
            }
        }
    }

    private class doThFilterImpl_BUFFERFORMAT_WORD1D_R5G6B5_16LE
    implements IdoThFilterImpl {
        private doThFilterImpl_BUFFERFORMAT_WORD1D_R5G6B5_16LE() {
        }

        @Override
        public void doThFilter(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int i_th, INyARRaster o_raster) {
            int pt_dst;
            int skip_dst;
            assert (i_raster.isEqualBufferType(197121));
            short[] input = (short[])i_raster.getBuffer();
            int[] output = (int[])o_raster.getBuffer();
            int th = i_th * 3;
            NyARIntSize s = i_raster.getSize();
            int skip_src = skip_dst = s.w - i_w;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_src = pt_dst = i_t * s.w + i_l;
            int y = i_h - 1;
            while (y >= 0) {
                short v;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    --x;
                }
                while (x >= 0) {
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    v = input[pt_src++];
                    output[pt_dst++] = ((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3) <= th ? 0 : 1;
                    x -= 8;
                }
                pt_src += skip_src;
                pt_dst += skip_dst;
                --y;
            }
        }
    }
}

