/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.mklib;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.stack.NyARObjectStack;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerParam;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPickup;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerDataEncoder_RawBitId;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerData_RawBitId;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTarget;
import jp.nyatla.nyartoolkit.rpf.realitysource.nyartk.NyARRealitySource;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARRectTargetStatus;

public class RawbitSerialIdTable {
    private SerialTable _table;
    private final NyIdMarkerPickup _id_pickup = new NyIdMarkerPickup();
    private NyIdMarkerPattern _temp_nyid_info = new NyIdMarkerPattern();
    private NyIdMarkerParam _temp_nyid_param = new NyIdMarkerParam();
    private NyIdMarkerDataEncoder_RawBitId _rb = new NyIdMarkerDataEncoder_RawBitId();
    private NyIdMarkerData_RawBitId _rb_dest = new NyIdMarkerData_RawBitId();

    public RawbitSerialIdTable(int i_max) throws NyARException {
        this._table = new SerialTable(i_max);
    }

    public boolean addSerialIdRangeItem(String i_name, long i_st, long i_ed, double i_width) {
        SerialTable.SerialTableRow d = (SerialTable.SerialTableRow)this._table.prePush();
        if (d == null) {
            return false;
        }
        d.setValue(i_name, i_st, i_ed, i_width);
        return true;
    }

    public boolean addSerialIdItem(String i_name, long i_serial, double i_width) {
        SerialTable.SerialTableRow d = (SerialTable.SerialTableRow)this._table.prePush();
        if (d == null) {
            return false;
        }
        d.setValue(i_name, i_serial, i_serial, i_width);
        return true;
    }

    public boolean addAnyItem(String i_name, double i_width) {
        SerialTable.SerialTableRow d = (SerialTable.SerialTableRow)this._table.prePush();
        if (d == null) {
            return false;
        }
        d.setValue(i_name, 0L, Long.MAX_VALUE, i_width);
        return true;
    }

    public final boolean identifyId(NyARDoublePoint2d[] i_vertex, INyARRgbRaster i_raster, IdentifyIdResult o_result) throws NyARException {
        if (!this._id_pickup.pickFromRaster(i_raster, i_vertex, this._temp_nyid_info, this._temp_nyid_param)) {
            return false;
        }
        if (!this._rb.encode(this._temp_nyid_info, this._rb_dest)) {
            return false;
        }
        SerialTable.SerialTableRow d = this._table.getItembySerialId(this._rb_dest.marker_id);
        if (d == null) {
            return false;
        }
        o_result.marker_width = d.marker_width;
        o_result.id = this._rb_dest.marker_id;
        o_result.artk_direction = this._temp_nyid_param.direction;
        o_result.name = d.name;
        return true;
    }

    public boolean identifyId(NyARRealityTarget i_target, NyARRealitySource i_rtsorce, IdentifyIdResult o_result) throws NyARException {
        return this.identifyId(((NyARRectTargetStatus)i_target._ref_tracktarget._ref_status).vertex, i_rtsorce.refRgbSource(), o_result);
    }

    public static class IdentifyIdResult {
        public long id;
        public String name;
        public double marker_width;
        public int artk_direction;
    }

    private class SerialTable
    extends NyARObjectStack<SerialTableRow> {
        public SerialTable(int i_length) throws NyARException {
            super.initInstance(i_length, SerialTableRow.class);
        }

        @Override
        protected SerialTableRow createElement() {
            return new SerialTableRow();
        }

        public SerialTableRow getItembySerialId(long i_serial) {
            int i = this._length - 1;
            while (i >= 0) {
                SerialTableRow s = ((SerialTableRow[])this._items)[i];
                if (i_serial >= s.id_st && i_serial <= s.id_ed) {
                    return s;
                }
                --i;
            }
            return null;
        }

        public class SerialTableRow {
            public long id_st;
            public long id_ed;
            public double marker_width;
            public String name;

            public final void setValue(String i_name, long i_st, long i_ed, double i_width) {
                this.id_ed = i_ed;
                this.id_st = i_st;
                this.marker_width = i_width;
                this.name = i_name;
            }
        }
    }
}

