/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import saito.objloader.OBJModel;

public class OBJLoader_Sample_SAITO
extends PApplet {
    OBJModel model;
    float rotX;
    float rotY;
    boolean bTexture = true;
    boolean bStroke = false;

    public void setup() {
        this.size(800, 600, "processing.core.PGraphics3D");
        this.frameRate(30.0f);
        this.model = new OBJModel((PApplet)this, "dma.obj", "absolute", 9);
        this.model.enableDebug();
        this.model.scale(20.0f);
        this.model.translateToCenter();
        this.stroke(255);
        this.noStroke();
    }

    public void draw() {
        this.background(129);
        this.lights();
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateX(this.rotY);
        this.rotateY(this.rotX);
        this.model.draw();
        this.popMatrix();
    }

    public void keyPressed() {
        if (this.key == 't') {
            if (!this.bTexture) {
                this.model.enableTexture();
                this.bTexture = true;
            } else {
                this.model.disableTexture();
                this.bTexture = false;
            }
        }
        if (this.key == 's') {
            if (!this.bStroke) {
                this.stroke(255);
                this.bStroke = true;
            } else {
                this.noStroke();
                this.bStroke = false;
            }
        } else if (this.key == '1') {
            this.model.shapeMode(2);
        } else if (this.key == '2') {
            this.model.shapeMode(4);
        } else if (this.key == '3') {
            this.model.shapeMode(9);
        }
    }

    public void mouseDragged() {
        this.rotX += (float)(this.mouseX - this.pmouseX) * 0.01f;
        this.rotY -= (float)(this.mouseY - this.pmouseY) * 0.01f;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "OBJLoader_Sample_SAITO"});
    }
}

