/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.Reader;
import processing.xml.StdXMLReader;
import processing.xml.XMLEntityResolver;
import processing.xml.XMLParseException;
import processing.xml.XMLUtil;

class ContentReader
extends Reader {
    private StdXMLReader reader;
    private String buffer;
    private int bufferIndex;
    private XMLEntityResolver resolver;

    ContentReader(StdXMLReader reader, XMLEntityResolver resolver, String buffer) {
        this.reader = reader;
        this.resolver = resolver;
        this.buffer = buffer;
        this.bufferIndex = 0;
    }

    protected void finalize() throws Throwable {
        this.reader = null;
        this.resolver = null;
        this.buffer = null;
        super.finalize();
    }

    public int read(char[] outputBuffer, int offset, int size) throws IOException {
        try {
            int charsRead = 0;
            int bufferLength = this.buffer.length();
            if (offset + size > outputBuffer.length) {
                size = outputBuffer.length - offset;
            }
            while (charsRead < size) {
                char ch;
                String str = "";
                if (this.bufferIndex < bufferLength) {
                    ch = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    outputBuffer[charsRead] = ch;
                    ++charsRead;
                    continue;
                }
                str = XMLUtil.read(this.reader, '&');
                ch = str.charAt(0);
                if (ch == '<') {
                    this.reader.unread(ch);
                    break;
                }
                if (ch == '&' && str.length() > 1) {
                    if (str.charAt(1) == '#') {
                        ch = XMLUtil.processCharLiteral(str);
                    } else {
                        XMLUtil.processEntity(str, this.reader, this.resolver);
                        continue;
                    }
                }
                outputBuffer[charsRead] = ch;
                ++charsRead;
            }
            if (charsRead == 0) {
                charsRead = -1;
            }
            return charsRead;
        }
        catch (XMLParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            int bufferLength = this.buffer.length();
            while (true) {
                char ch;
                String str = "";
                if (this.bufferIndex < bufferLength) {
                    ch = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    continue;
                }
                str = XMLUtil.read(this.reader, '&');
                ch = str.charAt(0);
                if (ch == '<') {
                    this.reader.unread(ch);
                    break;
                }
                if (ch != '&' || str.length() <= 1 || str.charAt(1) == '#') continue;
                XMLUtil.processEntity(str, this.reader, this.resolver);
            }
        }
        catch (XMLParseException e) {
            throw new IOException(e.getMessage());
        }
    }
}

