/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.nio.ByteOrder;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.AppSink;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class BufferDataAppSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private AppSink sink;
    private Listener listener;
    private boolean autoDisposeBuffer = true;

    public BufferDataAppSink(String name, Listener listener) {
        super(BufferDataAppSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        String mask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF00, green_mask=(int)0xFF0000, blue_mask=(int)0xFF000000" : "red_mask=(int)0xFF0000, green_mask=(int)0xFF00, blue_mask=(int)0xFF";
        this.initSink(name, mask);
    }

    public BufferDataAppSink(String name, String mask, Listener listener) {
        super(BufferDataAppSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.initSink(name, mask);
    }

    public BufferDataAppSink(String name, Pipeline pipeline, Listener listener) {
        super(BufferDataAppSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        Element element = pipeline.getElementByName(name);
        if (element == null) {
            this.sink = null;
            throw new RuntimeException("Element with name " + name + " not found in the pipeline");
        }
        this.sink = (AppSink)element;
        this.sink.set("emit-signals", true);
        this.sink.set("sync", true);
        this.sink.connect(new AppSinkNewBufferListener());
    }

    private void initSink(String name, String mask) {
        this.sink = (AppSink)ElementFactory.make("appsink", name);
        this.sink.set("emit-signals", true);
        this.sink.set("sync", true);
        this.sink.connect(new AppSinkNewBufferListener());
        Element conv = ElementFactory.make("ffmpegcolorspace", "ColorConverter");
        Element videofilter = ElementFactory.make("capsfilter", "ColorFilter");
        StringBuilder caps = new StringBuilder("video/x-raw-rgb, bpp=32, depth=24, endianness=(int)4321, ");
        caps.append(mask);
        videofilter.setCaps(new Caps(caps.toString()));
        this.addMany(conv, videofilter, this.sink);
        Element.linkMany(conv, videofilter, this.sink);
        this.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
    }

    public void removeListener() {
        this.listener = null;
    }

    public void setAutoDisposeBuffer(boolean autoDispose) {
        this.autoDisposeBuffer = autoDispose;
    }

    public BaseSink getSinkElement() {
        return this.sink;
    }

    public Caps getCaps() {
        return this.sink.getCaps();
    }

    class AppSinkNewBufferListener
    implements AppSink.NEW_BUFFER {
        AppSinkNewBufferListener() {
        }

        public void newBuffer(AppSink elem) {
            Buffer buffer = BufferDataAppSink.this.sink.pullBuffer();
            Caps caps = buffer.getCaps();
            Structure struct = caps.getStructure(0);
            int width = struct.getInteger("width");
            int height = struct.getInteger("height");
            if (width < 1 || height < 1) {
                return;
            }
            BufferDataAppSink.this.listener.bufferFrame(width, height, buffer);
            if (BufferDataAppSink.this.autoDisposeBuffer) {
                buffer.dispose();
            }
        }
    }

    public static interface Listener {
        public void bufferFrame(int var1, int var2, Buffer var3);
    }
}

