/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Event;
import org.gstreamer.FlowReturn;
import org.gstreamer.PadDirection;
import org.gstreamer.PadTemplate;
import org.gstreamer.elements.BaseSrc;
import org.gstreamer.lowlevel.BaseSrcAPI;
import org.gstreamer.lowlevel.GObjectAPI;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstPadTemplateAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomSrc
extends BaseSrc {
    private static final Logger logger = Logger.getLogger(CustomSrc.class.getName());
    private static final Map<Class<? extends CustomSrc>, CustomSrcInfo> customSubclasses = new ConcurrentHashMap<Class<? extends CustomSrc>, CustomSrcInfo>();
    private static final BaseSrcAPI.Create fillBufferCallback = new BaseSrcAPI.Create(){

        public FlowReturn callback(BaseSrc element, long offset, int size, Pointer bufRef) {
            try {
                Buffer buffer = new Buffer(size);
                FlowReturn retVal = ((CustomSrc)element).srcFillBuffer(offset, size, buffer);
                bufRef.setPointer(0L, buffer.getAddress());
                buffer.disown();
                return retVal;
            }
            catch (Exception ex) {
                return FlowReturn.UNEXPECTED;
            }
        }
    };
    private static final BaseSrcAPI.Create createBufferCallback = new BaseSrcAPI.Create(){

        public FlowReturn callback(BaseSrc element, long offset, int size, Pointer bufRef) {
            try {
                Buffer[] buffers = new Buffer[1];
                FlowReturn retVal = ((CustomSrc)element).srcCreateBuffer(offset, size, buffers);
                if (buffers[0] != null) {
                    Buffer buffer = buffers[0];
                    bufRef.setPointer(0L, buffer.getAddress());
                    buffer.disown();
                }
                return retVal;
            }
            catch (Exception ex) {
                return FlowReturn.UNEXPECTED;
            }
        }
    };
    private static final BooleanFunc1 isSeekableCallback = new BooleanFunc1("srcIsSeekable");
    private static final BooleanFunc1 startCallback = new BooleanFunc1("srcStart");
    private static final BooleanFunc1 stopCallback = new BooleanFunc1("srcStop");
    private static final BooleanFunc1 negotiateCallback = new BooleanFunc1("srcNegotiate");
    private static final BaseSrcAPI.Seek seekCallback = new BaseSrcAPI.Seek(){

        public boolean callback(BaseSrc element, GstAPI.GstSegmentStruct segment) {
            try {
                return ((CustomSrc)element).srcSeek(segment);
            }
            catch (Exception ex) {
                return false;
            }
        }
    };
    private static final BaseSrcAPI.SetCaps setCapsCallback = new BaseSrcAPI.SetCaps(){

        public boolean callback(BaseSrc element, Caps caps) {
            try {
                return ((CustomSrc)element).srcSetCaps(caps);
            }
            catch (Exception ex) {
                return false;
            }
        }
    };
    private static final BaseSrcAPI.GetCaps getCapsCallback = new BaseSrcAPI.GetCaps(){

        public Caps callback(BaseSrc element) {
            try {
                Caps caps = ((CustomSrc)element).srcGetCaps().copy();
                caps.disown();
                return caps;
            }
            catch (Exception ex) {
                Caps caps = Caps.emptyCaps();
                caps.disown();
                return caps;
            }
        }
    };
    private static final BaseSrcAPI.GetTimes getTimesCallback = new BaseSrcAPI.GetTimes(){

        public void callback(BaseSrc src, Buffer buffer, Pointer startRef, Pointer endRef) {
            try {
                long[] start = new long[]{-1L};
                long[] end = new long[]{-1L};
                ((CustomSrc)src).srcGetTimes(buffer, start, end);
                startRef.setLong(0L, start[0]);
                endRef.setLong(0L, end[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    };
    private static final BaseSrcAPI.Fixate fixateCallback = new BaseSrcAPI.Fixate(){

        public void callback(BaseSrc src, Caps caps) {
            ((CustomSrc)src).srcFixate(caps);
        }
    };
    private static final BaseSrcAPI.EventNotify eventCallback = new BaseSrcAPI.EventNotify(){

        public boolean callback(BaseSrc src, Event ev) {
            try {
                return ((CustomSrc)src).srcEvent(ev);
            }
            catch (Exception ex) {
                return false;
            }
        }
    };
    private static final BaseSrcAPI.GetSize getSizeCallback = new BaseSrcAPI.GetSize(){

        public boolean callback(BaseSrc element, LongByReference sizeRef) {
            try {
                long size = ((CustomSrc)element).srcGetSize();
                if (size < 0L) {
                    return false;
                }
                sizeRef.setValue(size);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    };

    protected CustomSrc(Class<? extends CustomSrc> subClass, String name) {
        super(CustomSrc.initializer(GObjectAPI.GOBJECT_API.g_object_new(CustomSrc.getSubclassType(subClass), "name", name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CustomSrcInfo getSubclassInfo(Class<? extends CustomSrc> subClass) {
        Class<? extends CustomSrc> clazz = subClass;
        synchronized (clazz) {
            CustomSrcInfo info = customSubclasses.get(subClass);
            if (info == null) {
                CustomSrc.init(subClass);
                info = customSubclasses.get(subClass);
            }
            return info;
        }
    }

    private static GType getSubclassType(Class<? extends CustomSrc> subClass) {
        return CustomSrc.getSubclassInfo(subClass).type;
    }

    @SrcCallback(value="create")
    protected FlowReturn srcCreateBuffer(long offset, int size, Buffer[] bufRef) throws IOException {
        return FlowReturn.NOT_SUPPORTED;
    }

    @SrcCallback(value="create")
    protected FlowReturn srcFillBuffer(long offset, int size, Buffer buffer) throws IOException {
        logger.info("CustomSrc.srcFillBuffer");
        return FlowReturn.NOT_SUPPORTED;
    }

    @SrcCallback(value="is_seekable")
    protected boolean srcIsSeekable() {
        logger.info("CustomSrc.srcIsSeekable");
        return false;
    }

    @SrcCallback(value="seek")
    protected boolean srcSeek(GstAPI.GstSegmentStruct segment) throws IOException {
        logger.info("CustomSrc.srcSeek");
        return false;
    }

    @SrcCallback(value="start")
    protected boolean srcStart() {
        logger.info("CustomSrc.srcStart");
        return true;
    }

    @SrcCallback(value="stop")
    protected boolean srcStop() {
        logger.info("CustomSrc.srcStop");
        return true;
    }

    @SrcCallback(value="negotiate")
    protected boolean srcNegotiate() {
        logger.info("CustomSrc.srcNegotiate");
        return false;
    }

    @SrcCallback(value="get_caps")
    protected Caps srcGetCaps() {
        logger.info("CustomSrc.srcGetCaps");
        return null;
    }

    @SrcCallback(value="set_caps")
    protected boolean srcSetCaps(Caps caps) {
        logger.info("CustomSrc.srcSetCaps");
        return false;
    }

    @SrcCallback(value="get_size")
    protected long srcGetSize() {
        logger.info("CustomSrc.srcGetSize");
        return -1L;
    }

    @SrcCallback(value="event")
    protected boolean srcEvent(Event ev) {
        logger.info("CustomSrc.srcEvent");
        return true;
    }

    @SrcCallback(value="get_times")
    protected void srcGetTimes(Buffer buffer, long[] start, long[] end) {
        logger.info("CustomSrc.srcGetTimes");
    }

    @SrcCallback(value="fixate")
    protected void srcFixate(Caps caps) {
        logger.info("CustomSrc.srcFixate");
    }

    private static final boolean isOverridingMethod(Method m1, Method m2) {
        return m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass()) && m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass()) && m1.getName().equals(m2.getName()) && m1.getReturnType().equals(m2.getReturnType()) && m1.getParameterTypes() != null && m2.getParameterTypes() != null && Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    private static final Method findOverridingMethod(Class<?> cls, Method method) {
        for (Class<?> next = cls; next != null; next = next.getSuperclass()) {
            for (Method m : next.getDeclaredMethods()) {
                if (!CustomSrc.isOverridingMethod(method, m)) continue;
                return m;
            }
        }
        return null;
    }

    private static void init(Class<? extends CustomSrc> srcClass) {
        GType type;
        final CustomSrcInfo info = new CustomSrcInfo();
        customSubclasses.put(srcClass, info);
        for (Method m : CustomSrc.class.getDeclaredMethods()) {
            Method srcMethod;
            SrcCallback cb = m.getAnnotation(SrcCallback.class);
            if (cb == null || (srcMethod = CustomSrc.findOverridingMethod(srcClass, m)) == null || srcMethod.equals(m)) continue;
            if (m.getName().equals("srcSeek")) {
                info.seek = seekCallback;
                continue;
            }
            if (m.getName().equals("srcIsSeekable")) {
                info.is_seekable = isSeekableCallback;
                continue;
            }
            if (m.getName().equals("srcFillBuffer")) {
                info.create = fillBufferCallback;
                continue;
            }
            if (m.getName().equals("srcCreateBuffer")) {
                info.create = createBufferCallback;
                continue;
            }
            if (m.getName().equals("srcStart")) {
                info.start = startCallback;
                continue;
            }
            if (m.getName().equals("srcStop")) {
                info.stop = stopCallback;
                continue;
            }
            if (m.getName().equals("srcNegotiate")) {
                info.negotiate = negotiateCallback;
                continue;
            }
            if (m.getName().equals("srcSetCaps")) {
                info.set_caps = setCapsCallback;
                continue;
            }
            if (m.getName().equals("srcGetCaps")) {
                info.get_caps = getCapsCallback;
                continue;
            }
            if (m.getName().equals("srcGetSize")) {
                info.get_size = getSizeCallback;
                continue;
            }
            if (m.getName().equals("srcGetTimes")) {
                info.get_times = getTimesCallback;
                continue;
            }
            if (m.getName().equals("srcFixate")) {
                info.fixate = fixateCallback;
                continue;
            }
            if (!m.getName().equals("srcEvent")) continue;
            info.event = eventCallback;
        }
        info.classInit = new GObjectAPI.GClassInitFunc(){

            public void callback(Pointer g_class, Pointer class_data) {
                BaseSrcAPI.GstBaseSrcClass base = new BaseSrcAPI.GstBaseSrcClass(g_class);
                for (Field f : ((Object)((Object)base)).getClass().getDeclaredFields()) {
                    try {
                        Field infoField = info.getClass().getDeclaredField(f.getName());
                        if (!f.getType().isAssignableFrom(infoField.getType())) continue;
                        f.set((Object)base, infoField.get(info));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                base.write();
            }
        };
        info.baseInit = new GObjectAPI.GBaseInitFunc(){

            public void callback(Pointer g_class) {
                info.caps = Caps.anyCaps();
                info.template = new PadTemplate("src", PadDirection.SRC, info.caps);
                GstPadTemplateAPI.GSTPADTEMPLATE_API.gst_element_class_add_pad_template(g_class, info.template);
            }
        };
        GObjectAPI.GTypeInfo ginfo = new GObjectAPI.GTypeInfo();
        ginfo.class_init = info.classInit;
        ginfo.base_init = info.baseInit;
        ginfo.instance_init = null;
        ginfo.class_size = (short)new BaseSrcAPI.GstBaseSrcClass().size();
        ginfo.instance_size = (short)new BaseSrcAPI.GstBaseSrcStruct().size();
        info.type = type = GObjectAPI.GOBJECT_API.g_type_register_static(BaseSrcAPI.BASESRC_API.gst_base_src_get_type(), srcClass.getSimpleName(), ginfo, 0);
    }

    private static class BooleanFunc1
    implements BaseSrcAPI.BooleanFunc1 {
        private Method method;

        public BooleanFunc1(String methodName) {
            try {
                this.method = CustomSrc.class.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean callback(BaseSrc element) {
            try {
                return (Boolean)this.method.invoke((Object)element, new Object[0]);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface SrcCallback {
        public String value();
    }

    private static class CustomSrcInfo {
        GType type;
        PadTemplate template;
        Caps caps;
        GObjectAPI.GClassInitFunc classInit;
        GObjectAPI.GBaseInitFunc baseInit;
        BaseSrcAPI.Create create;
        BaseSrcAPI.Seek seek;
        BooleanFunc1 is_seekable;
        BooleanFunc1 start;
        BooleanFunc1 stop;
        BooleanFunc1 negotiate;
        BaseSrcAPI.GetCaps get_caps;
        BaseSrcAPI.SetCaps set_caps;
        BaseSrcAPI.GetSize get_size;
        BaseSrcAPI.GetTimes get_times;
        BaseSrcAPI.Fixate fixate;
        BaseSrcAPI.EventNotify event;

        private CustomSrcInfo() {
        }
    }
}

