/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.elements.RGBDataSink;
import org.gstreamer.swt.VideoComponent;

public class SWTVideoTest {
    private static List<VideoComponent> components;

    private static void createControl(Composite parent) {
        Composite controlComposite = new Composite(parent, 0);
        controlComposite.setLayout((Layout)new GridLayout(3, false));
        controlComposite.setLayoutData((Object)new GridData(768));
        final Composite componentComposite = new Composite(parent, 0);
        componentComposite.setLayout((Layout)new GridLayout(1, false));
        componentComposite.setLayoutData((Object)new GridData(1808));
        final Spinner num = new Spinner(controlComposite, 0);
        num.setMinimum(1);
        num.setMaximum(20);
        Button add = new Button(controlComposite, 0);
        add.setText("Add");
        add.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ArrayList<VideoComponent> temp = new ArrayList<VideoComponent>();
                if (components.size() == 0 && num.getSelection() == 1) {
                    componentComposite.setLayout((Layout)new GridLayout(1, false));
                } else {
                    componentComposite.setLayout((Layout)new GridLayout((components.size() + num.getSelection()) / 2, false));
                }
                for (int i = 0; i < num.getSelection(); ++i) {
                    temp.add(SWTVideoTest.createComponenet(componentComposite));
                }
                componentComposite.layout();
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (VideoComponent videoComponent : temp) {
                    final Pipeline pipeline = (Pipeline)videoComponent.getData();
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            pipeline.play();
                        }
                    }, "pipeline");
                    threads.add(thread);
                }
                for (Thread thread : threads) {
                    thread.start();
                }
            }
        });
        Button delete = new Button(controlComposite, 0);
        delete.setText("Delete");
        delete.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                for (int i = 0; i < num.getSelection(); ++i) {
                    if (components.size() <= 0) continue;
                    VideoComponent component = (VideoComponent)((Object)components.get(components.size() - 1));
                    SWTVideoTest.deleteElement(component);
                }
                componentComposite.layout();
            }
        });
    }

    private static void deleteElement(VideoComponent component) {
        Pipeline pipeline = (Pipeline)component.getData();
        pipeline.stop();
        pipeline.getState().equals(State.NULL);
        component.dispose();
        components.remove((Object)component);
    }

    private static VideoComponent createComponenet(Composite parent) {
        Pipeline pipe = new Pipeline("SWT Overlay Test");
        Element src = ElementFactory.make("videotestsrc", "videotest");
        VideoComponent component = new VideoComponent(parent, 0);
        component.getElement().setName("video");
        component.setKeepAspect(true);
        component.setLayoutData(new GridData(1808));
        RGBDataSink sink = component.getElement();
        component.setData(pipe);
        components.add(component);
        pipe.addMany(src, sink);
        Element.linkMany(src, sink);
        return component;
    }

    public static void main(String[] args) {
        args = Gst.init("SWTVideoTest", args);
        components = new ArrayList<VideoComponent>();
        try {
            Display display = new Display();
            Shell shell = new Shell(display);
            shell.setMaximized(true);
            shell.setLayout((Layout)new GridLayout(1, false));
            shell.setText("SWT Video Test");
            SWTVideoTest.createControl((Composite)shell);
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    ArrayList temp = new ArrayList();
                    temp.addAll(components);
                    for (VideoComponent component : temp) {
                        SWTVideoTest.deleteElement(component);
                    }
                }
            });
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

