/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swing;

import com.sun.jna.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gstreamer.State;
import org.gstreamer.media.MediaPlayer;
import org.gstreamer.media.PlayBinMediaPlayer;
import org.gstreamer.media.event.EndOfMediaEvent;
import org.gstreamer.media.event.MediaAdapter;
import org.gstreamer.media.event.MediaListener;
import org.gstreamer.media.event.StartEvent;
import org.gstreamer.media.event.StopEvent;
import org.gstreamer.swing.PipelinePositionModel;
import org.gstreamer.swing.PopupVolumeButton;
import org.gstreamer.swing.SwingExecutorService;
import org.gstreamer.swing.VideoComponent;

public class VideoPlayer
extends JPanel {
    private static final long serialVersionUID = 1964694975227372646L;
    private static final SwingExecutorService swingExec = new SwingExecutorService();
    ImageIcon playIcon = VideoPlayer.loadIcon("actions/media-playback-start");
    ImageIcon pauseIcon = VideoPlayer.loadIcon("actions/media-playback-pause");
    ImageIcon stopIcon = VideoPlayer.loadIcon("actions/media-playback-stop");
    ImageIcon fwdIcon = VideoPlayer.loadIcon("actions/media-seek-forward");
    ImageIcon rewIcon = VideoPlayer.loadIcon("actions/media-seek-backward");
    private AbstractAction playAction = new AbstractAction("", this.playIcon){
        private static final long serialVersionUID = 1714683114563367993L;

        public void actionPerformed(ActionEvent e) {
            VideoPlayer.this.mediaPlayer.play();
        }
    };
    private AbstractAction pauseAction = new AbstractAction("", this.pauseIcon){
        private static final long serialVersionUID = 1045795748586088103L;

        public void actionPerformed(ActionEvent e) {
            VideoPlayer.this.mediaPlayer.pause();
        }
    };
    private AbstractAction stopAction = new AbstractAction("", this.stopIcon){
        private static final long serialVersionUID = 881154743003615413L;

        public void actionPerformed(ActionEvent e) {
            VideoPlayer.this.mediaPlayer.stop();
        }
    };
    private AbstractAction fwdAction = new AbstractAction("", this.fwdIcon){
        private static final long serialVersionUID = -6661129153122209564L;

        public void actionPerformed(ActionEvent e) {
            VideoPlayer.this.positionModel.setValue(VideoPlayer.this.positionModel.getValue() + 60);
        }
    };
    private AbstractAction rewAction = new AbstractAction("", this.rewIcon){
        private static final long serialVersionUID = 4450598460336990513L;

        public void actionPerformed(ActionEvent e) {
            VideoPlayer.this.positionModel.setValue(VideoPlayer.this.positionModel.getValue() - 60);
        }
    };
    private MediaListener mediaListener = new MediaAdapter(){

        public void endOfMedia(EndOfMediaEvent evt) {
            this.stop(evt);
        }

        public void pause(StopEvent evt) {
            VideoPlayer.this.pauseAction.setEnabled(false);
            VideoPlayer.this.playAction.setEnabled(true);
            VideoPlayer.this.togglePlayAction.setState(State.PAUSED);
        }

        public void start(StartEvent evt) {
            VideoPlayer.this.playAction.setEnabled(false);
            VideoPlayer.this.pauseAction.setEnabled(true);
            VideoPlayer.this.stopAction.setEnabled(true);
            VideoPlayer.this.togglePlayAction.setState(State.PLAYING);
        }

        public void stop(StopEvent evt) {
            VideoPlayer.this.playAction.setEnabled(true);
            VideoPlayer.this.pauseAction.setEnabled(false);
            VideoPlayer.this.stopAction.setEnabled(false);
            VideoPlayer.this.togglePlayAction.setState(State.NULL);
        }
    };
    private TogglePlayAction togglePlayAction = new TogglePlayAction();
    private BoundedRangeModel volumeModel = new DefaultBoundedRangeModel(){
        private static final long serialVersionUID = -4728390119456427400L;

        public int getMaximum() {
            return 100;
        }

        public int getMinimum() {
            return 0;
        }

        public int getValue() {
            return Math.min(100, (int)(VideoPlayer.this.mediaPlayer.getVolume() * 100.0 + 0.5));
        }

        public void setValue(int percent) {
            double volume = Math.max(Math.min((double)percent, 100.0), 0.0) / 100.0;
            VideoPlayer.this.mediaPlayer.setVolume(volume);
        }
    };
    PipelinePositionModel positionModel;
    private MediaPlayer mediaPlayer;
    private JComponent controls;
    private JLabel positionLabel;
    private VideoComponent videoComponent;

    public VideoPlayer(MediaPlayer player) {
        this.mediaPlayer = player;
        this.videoComponent = new VideoComponent();
        this.mediaPlayer.setVideoSink(this.videoComponent.getElement());
        this.setLayout(new BorderLayout());
        this.add((Component)this.videoComponent, "Center");
        this.controls = new JPanel();
        this.controls.setLayout(new BoxLayout(this.controls, 0));
        this.add((Component)this.controls, "South");
        this.controls.add(new PopupVolumeButton(this.volumeModel));
        this.controls.add(new JButton(this.rewAction));
        this.controls.add(new JButton(this.togglePlayAction));
        this.controls.add(new JButton(this.fwdAction));
        this.playAction.setEnabled(true);
        this.pauseAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        Object paintValue = UIManager.put("Slider.paintValue", Boolean.FALSE);
        this.positionModel = new PipelinePositionModel(this.mediaPlayer.getPipeline());
        this.controls.add(new JSlider(this.positionModel));
        UIManager.put("Slider.paintValue", paintValue);
        this.positionLabel = new JLabel("00:00:00");
        this.controls.add(this.positionLabel);
        if (Platform.isMac()) {
            Box spacer = Box.createHorizontalBox();
            spacer.add(Box.createHorizontalStrut(16));
            this.controls.add(spacer);
        }
        this.controls.setVisible(false);
        this.positionModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BoundedRangeModel m = (BoundedRangeModel)e.getSource();
                int value = m.getValue();
                String text = String.format("%02d:%02d:%02d", value / 3600, value / 60 % 60, value % 60);
                VideoPlayer.this.positionLabel.setText(text);
            }
        });
        this.mediaPlayer.addMediaListener(swingExec.wrap(MediaListener.class, this.mediaListener));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                for (KeyListener l : VideoPlayer.this.videoComponent.getKeyListeners()) {
                    l.keyPressed(evt);
                }
            }

            public void keyReleased(KeyEvent evt) {
                for (KeyListener l : VideoPlayer.this.videoComponent.getKeyListeners()) {
                    l.keyReleased(evt);
                }
            }
        });
    }

    public VideoPlayer(File file) {
        this(file.toURI());
    }

    public VideoPlayer(String uri) {
        this(VideoPlayer.parseURI(uri));
    }

    public VideoPlayer(URI uri) {
        this(new PlayBinMediaPlayer("swing player", (Executor)swingExec));
        this.mediaPlayer.setURI(uri);
    }

    private static URI parseURI(String uri) {
        try {
            URI u = new URI(uri);
            if (u.getScheme() == null) {
                throw new URISyntaxException(uri, "Invalid URI scheme");
            }
            return u;
        }
        catch (URISyntaxException e) {
            File f = new File(uri);
            if (!f.exists()) {
                throw new IllegalArgumentException("Invalid URI/file " + uri, e);
            }
            return f.toURI();
        }
    }

    public VideoComponent getVideoComponent() {
        return this.videoComponent;
    }

    public void setOpacity(float alpha) {
        float[] c = this.getBackground().getColorComponents(new float[3]);
        this.setBackground(new Color(c[0], c[1], c[2], alpha));
        this.videoComponent.setOpacity(alpha);
    }

    public float getOpacity() {
        return this.videoComponent.getOpacity();
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.videoComponent != null) {
            this.videoComponent.setOpaque(isOpaque);
        }
    }

    public void setKeepAspect(boolean keepAspect) {
        this.videoComponent.setKeepAspect(keepAspect);
    }

    public void setControlsVisible(boolean visible) {
        this.controls.setVisible(visible);
        this.revalidate();
    }

    public void setURI(URI uri) {
        this.mediaPlayer.setURI(uri);
    }

    public void setInputFile(File file) {
        this.mediaPlayer.setURI(file.toURI());
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    private static ImageIcon loadIcon(String name) {
        return VideoPlayer.loadIcon(16, name);
    }

    private static ImageIcon loadIcon(int size, String name) {
        String path = "/org/freedesktop/tango/" + size + "x" + size + "/" + name + ".png";
        URL url = VideoPlayer.class.getResource(path);
        if (url != null) {
            return new ImageIcon(url);
        }
        throw new RuntimeException("Cannot locate icon for " + name);
    }

    private class TogglePlayAction
    extends AbstractAction {
        private static final long serialVersionUID = -333774735255804279L;

        public TogglePlayAction() {
            super("", VideoPlayer.this.pauseIcon);
        }

        public void setState(State state) {
            switch (state) {
                case PAUSED: 
                case NULL: {
                    this.putValue("SmallIcon", VideoPlayer.this.playIcon);
                    break;
                }
                default: {
                    this.putValue("SmallIcon", VideoPlayer.this.pauseIcon);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (VideoPlayer.this.mediaPlayer.isPlaying()) {
                VideoPlayer.this.mediaPlayer.pause();
                this.setState(State.PAUSED);
            } else {
                VideoPlayer.this.mediaPlayer.play();
                this.setState(State.PLAYING);
            }
        }
    }
}

