/**  Affiche tactile interactive - 
*  Quand on appuie sur une touche, cela lance une image, une vidéo, une annim, un son, etc...
*/
/// librairies
import processing.sound.*;
import processing.video.*; 


// variables globales
///////screamer
PImage errorMessageImage, screamImage; // our stocked images.
PFont font; // the font for the message.
final int timeToError = 300; // playing time needed to print the error on screen (in frame)
final String messageOnScreen = "Utilisez la souris"; // the message drawn on screen to invite users to play with
int phase = 0; //actual phase of the program
final int
  PLAY =   0, // the user is playing (points are drawn)
  BUG =    1, // the user can see an error message
  SCREAM = 2  // the user has clicked or used the keyboard and can now see a screamer
;

///// fin scereamer

//================
//    PHASE A
//================
final int
  frameTrigger = 120; //frames before user is considered as Inactive

int playingTime = 0, framesOfInactivity = 0, falloff = 50;
int2 mouseBufferedPosition; // the last mouse position
//// fin phase A

//================
//    PHASE B
//================

color errorBG;// the backgroung color for error
///fin phase B 

//================
//    PHASE C
//================
SoundFile screamSound;
///fin phase C


/////
PImage im; // une image
SoundFile son; // un son
Movie vid; // une vidéo
Movie vid2; 

// bouton son image active ?
boolean image_active = false;

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton video active ?
boolean video_active = false;

// variables liées à l'animation
boolean anim_active = false;

/// bouton video active ?
boolean video_active2 = false;
   
   
void setup() {
  size(500, 500);
  noStroke();
  background(0);
  
  // initialisation des variables globales
  im = loadImage("images/chien.jpg");
  
  // chargement du son
  son = new SoundFile(this, "sons/beat.aiff");
  //println(son.duration());
  
  // chargement des videos
  vid = new Movie(this, "videos/affiche.mp4"); 
  vid.loop();
  
  vid2 = new Movie(this, "videos/giffrac.mp4");
  vid2.loop(); 
  
  // init des variables liées à l'annimation
  //==== Loading images =======
  errorMessageImage = loadImage("tÇlÇchargÇ.jpg");
  screamImage = loadImage("scream.jpg");
  
  //loading the font
  font = createFont("comic.ttf", 48); // font name, font size
  textFont(font);
  errorBG = color (32, 103, 178);
  
  //loading audio for screaming
  screamSound = new SoundFile (this, "scream.mp3");
 
}

void draw() { 
 
  // gestion du son ////////////////////////////////////////
  // test du temps pendant lequel le son est joué
  //debug
  println("son_actif = "+ son_actif);
  // fin debug
  
  if (son_actif){
    float tempsEcoute = millis() - tempsDebutSon ;

   // debug 
    println("tempsDebutSon = " + tempsDebutSon);
    println("tempsEcoute = " + tempsEcoute);
    println("durée du son " + son.duration());
    // fin debug
    
    if ( tempsEcoute >= son.duration()*1000){ // si le son est fini
      son_actif = false; // bouton son_actif off
    }
  }
  
    // gestion de la vidéo ////////////////////////////////////////
     if (video_active){
       image(vid, 0, 0, width, height);
     }
     if (video_active2){
       image(vid2, 0, 0, width, height);
     }
     
     // gestion de l'image
     if (image_active){
       float x = 30 + random(-20,20); // random sur la position
       float y = 30 + random(-20,20);
       image(im,x,y,200,200);
     }
     
     if (anim_active){
       //our main loop is here
       if (phase == PLAY)
        phaseA ();
       else if (phase == BUG)
         phaseB ();
       else
         phaseC();
     }
       
       
 }
 
 


void keyPressed() {
  if (key == CODED) {
    if (keyCode == LEFT) { // image
      image_active = !image_active;
    } 
    if (keyCode == RIGHT) { 
      vid2.play();
      video_active2 = true;
    }
    
    }
    if (keyCode == UP) { // video
      vid.play();
      video_active = true;
    }
    
    if (keyCode == DOWN) { // video
     
      anim_active = true;
    }
  }
  /// lié à scream
  


void movieEvent(Movie movie) {
  vid.read();  
}