
#include "Ultrasonic.h"

Ultrasonic ultrasonic(7);
int distance =354;
int inByte = 0;         // incoming serial byte
// debug
boolean debug = false;

void setup() {
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  establishContact();  // send a byte to establish contact until receiver responds

  // création du tableau d'octets 
}
void loop() {
  if (Serial.available() > 0) {
    // get incoming byte: vider le port série
    inByte = Serial.read();
    // lire la valeur de la distance
    distance = ultrasonic.MeasureInCentimeters();
    // envoyer la distance sur la port série sous la forme d'une chaine de caractères
    if (debug) {
      Serial.print("distance=");
      Serial.print(distance);//0~400cm
      Serial.println("cm");
    }
    else { // envoie des données brutes : un int est sur 2 octets
      Serial.write(0xFF & distance >> 8);// octet de poids fort
      Serial.write(0xFF & distance);// octet de poids faible
      
      
    }
    //delay(10);
  }
}

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}
