#include <CapacitiveSensor.h>

/*
   CapitiveSense Library Demo Sketch
   Paul Badger 2008
   Uses a high value resistor e.g. 10M between send pin and receive pin
   Resistor effects sensitivity, experiment with values, 50K - 50M. Larger resistor values yield larger sensor values.
   Receive pin is the sensor pin - try different amounts of foil/metal on this pin
*/

CapacitiveSensor   cs_2[] = {CapacitiveSensor(2, 4),  // 10M resistor between pins 4 & 2, pin 2 is sensor pin, add a wire and or foil if desired
                             CapacitiveSensor(2, 6),// 10M resistor between pins 4 & 6, pin 6 is sensor pin, add a wire and or foi
                             CapacitiveSensor(2, 8)// 10M resistor between pins 4 & 8, pin 8 is sensor pin, add a wire and or foil
                            };
long total[] = {0, 0, 0};


boolean debug = true;

void setup()
{
  cs_2[0].set_CS_AutocaL_Millis(0xFFFFFFFF);     // turn off autocalibrate on channel 1 - just as an example
  Serial.begin(9600);
}

void loop()
{
  long start = millis();
  for (int i = 0; i < 3; i++) {
    total[i] =  cs_2[i].capacitiveSensor(30);
  }

  if (debug) {
    Serial.print(millis() - start);        // check on performance in milliseconds
    Serial.print("\t");                    // tab character for debug windown spacing

    for (int i = 0; i < 3; i++) {
      Serial.print(total[i]);                  // print sensor output 1
      Serial.print("\t");
    }
    Serial.println("");                // print sensor output 3
  }


  delay(10);                             // arbitrary delay to limit data to serial port
}
