#librairies
import glob, random, sys, vlc, time
import RPi.GPIO as GPIO
from Adafruit_CharLCD import *


#variables globales

# début du programme

#vérification des dossiers contenant de la musique .mp3
if (len(sys.argv)) <=1:
    print("Merci de préciser un dossier contenant des fichiers .mp3")
    sys.exit(1)

folder = sys.argv[1]
files = glob.glob(folder+"/*.mp3")
print(files)
if (len(files) == 0):
    print("Il n'y a pas de fichiers .mp3 dans le dossier ", folder)
    sys.exit(1)


# setup des pattes GPIO du raspbery
GPIO.setmode(GPIO.BCM)

PLAY_BUTTON = 11
STOP_BUTTON = 7
BACK_BUTTON = 4
FORWARD_BUTTON = 10

GPIO.setup(PLAY_BUTTON,GPIO.IN)
GPIO.setup(STOP_BUTTON,GPIO.IN)
GPIO.setup(BACK_BUTTON,GPIO.IN)
GPIO.setup(FORWARD_BUTTON,GPIO.IN)

# gestion de l'afficheur LCD
lcd = Adafruit_CharLCD()
lcd.clear
lcd.message("lancement de la musique !!")
print("lancement de la musique !!")



# mode shuffle : met dans un ordre aléatoire tous les fichiers .mp3 contenu dans le tableau "files"
random.shuffle(files)

#chargement des fichiers dans vlc
player = vlc.MediaPlayer()
medialist = vlc.MediaList(files)
mlPlayer = vlc.MediaListPlayer()
mlPlayer.set_media_player(player)
mlPlayer.set_media_list(medialist)

def handle_changed_track(event, player):
    media = player.get_media()
    media.parse()
    artist = media.get_meta(vlc.Meta.Artist) or "Artiste inconnu"
    title = media.get_meta(vlc.Meta.Title) or "Titre de la chanson inconnu"
    album = media.get_meta(vlc.Meta.Album) or "Album de la chanson inconnu"
    lcd.clear()
    lcd.message(title + "\n" + artist + " - " + album)

playerem = player.event_manager()
playerem.event_attach(vlc.EventType.MediaPlayerMediaChanged, handle_changed_track, player)



# boucle infinie

while True:
    #button = input("Appuyer sur la touche : 1, 2, 3, ou 4 ___ ")
    if GPIO.input(PLAY_BUTTON): #bouton Play/Pause
        print("Le bouton Play a été pressé")
        #print(title)
        if mlPlayer.is_playing():
            mlPlayer.pause()
        else :
            mlPlayer.play();
    elif GPIO.input(STOP_BUTTON): #bouton pause
        print("Le bouton Stop a été pressé")
        mlPlayer.stop() #arrêter la musique

        random.shuffle(files) #met dans un ordre aléatoire tous les fichiers .mp3 contenu dans le tableau "files"
        medialist = vlc.MediaList(files)
        mlPlayer.set_media_list(medialist)

    elif GPIO.input(BACK_BUTTON):
        print("Le bouton Back a été pressé")
        mlPlayer.previous()
        
    elif GPIO.input(FORWARD_BUTTON):
        print("Le bouton Forward a été pressé")
        mlPlayer.next()
            
    time.sleep(0.3)
    lcd.scrollDisplayLeft()
    
